//
// 20.02.2025 www.satyria.de
//
// kernel.c
//

#include "led.h"
#include "screen.h"
#include "types.h"
#include "printf.h"
#include "getsystem.h"

int main (void)
{
   LED_off();
   Init_Screen();
	InitTerminal ();
    init_printf(0, putc);

	initgetsystem ();

    SetFrontColor(0x80, 0xa0, 0xff);
    printf("*****************************************************************************************\n");
    printf("***                                                                                   ***\n");
    printf("***                                (c) by Satyria                                     ***\n");
    printf("***                                                                                   ***\n");
    printf("*****************************************************************************************\n\n");
    SetFrontColor(0xff, 0xff, 0x00);
	 printf("Graphic:\n");
    SetFrontColor(0xff, 0xff, 0xff);
	 printf("The resolution of the screen is %u x %u pixels.\n",GetDisplayX(),GetDisplayY());
	 printf("Each pixel has a depth of %u bits.\n",GetDepth());
	 printf("Each line has %u bytes (pitch).\n",GetPitch());
	 printf("The screen can be reached from address %u.\n\n",GetGraphicsAddress());
    SetFrontColor(0xff, 0xff, 0x00);
	 printf("System:\n");
    SetFrontColor(0xff, 0xff, 0xff);
	 printf("The on-board revision is %u. This corresponds to the type %u.\n",GetBoardRevision(),(GetBoardRevision() >> 4) & 0xFF);
	 printf("The board has the following serial number: %u.\n\n",GetBoardSerial());
	 printf("The ARM processor has %u bytes available. These are accessible from address %u.\n",GetARMMemorySize(),GetARMMemoryBase());
	 printf("The VC processor has %u bytes available. These are accessible from address %u.\n",GetVCMemorySize(),GetVCMemoryBase());
	 
	LED_Error(2);
}
